#include "expression/Expression.h"

Expression::Expression(boost::shared_ptr<Reference> reference)
{
    this->text = AgString(REFERENCE_START()).append(reference->getImage()).append(REFERENCE_END());
}

Expression::Expression(const AgString & text)
{
    this->text = text;
}

AgString Expression::getText()
{
    return text;
}

AgString Expression::toString()
{
    return text;
}

bool Expression::equals(Expression* obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    Expression *other = dynamic_cast<Expression *>(obj);
    if (!other)
    {
        return false;
    }

    if (text != other->text) {
        return false;
    }

    return true;
}

Expression* Expression::clone()
{
    //TODO: need copy ASTStart* rootNode ?
    return new Expression("");
}


