#pragma once

#include "expression/Reference.h"
#include "util/Pointers.h"
#include <string>
#include <map>
#include <boost/shared_ptr.hpp>

class EvaluationEnvironment
{
private:
    boost::shared_ptr<Reference> cause;
    std::map< AgString, AgObjectPtr > environment;

public:
    boost::shared_ptr<Reference> getCause();
    void setCause(boost::shared_ptr<Reference> cause);
    std::map< AgString, AgObjectPtr > getEnvironment();
    void setEnvironment(std::map< AgString, AgObjectPtr > environment);

    EvaluationEnvironment();
    EvaluationEnvironment(boost::shared_ptr<Reference> cause);
    EvaluationEnvironment(std::map< AgString, AgObjectPtr > environment);
    EvaluationEnvironment(boost::shared_ptr< Reference> cause, std::map< AgString, AgObjectPtr > environment);
};
