#ifndef EnvironmentReferenceResolverH
#define EnvironmentReferenceResolverH

#include "expression/AbstractReferenceResolver.h"
#include <map>
#include <boost/shared_ptr.hpp>

class EnvironmentReferenceResolver : public AbstractReferenceResolver
{
private:
    std::map< AgString, boost::shared_ptr<AgObjectPtr> > environment;

public:
    void* resolveReference(boost::shared_ptr<Reference> ref, boost::shared_ptr<EvaluationEnvironment> resolvingEnvironment);
    void set(const AgString & variable, boost::shared_ptr<AgObjectPtr> value);
    boost::shared_ptr<AgObjectPtr> get(const AgString& variable);
    void setEnvironment(std::map< AgString, boost::shared_ptr<AgObjectPtr> > environment);
    std::map< AgString, boost::shared_ptr<AgObjectPtr> > getEnvironment();

	EnvironmentReferenceResolver();
};

#endif
