#pragma once

#include "expression/AbstractReferenceResolver.h"
#include <string>
#include <boost/shared_ptr.hpp>
#include "util/Pointers.h"

class DefaultReferenceResolver : public AbstractReferenceResolver
{
public:
    static AgString ROW() { return "row"; }
    static AgString DESCRIPTION() { return "description"; }
    static AgString NAME() { return "name"; }
    static AgString ICON() { return "icon"; }
    static AgString TYPE() { return "type"; }
    static AgString READABLE() { return "readable"; }
    static AgString WRITABLE() { return "writable"; }
    static AgString RECORDS() { return "records"; }
    static AgString FORMAT() { return "format"; }
    static AgString HELP() { return "help"; }
    static AgString OPTIONS() { return "options"; }
    static AgString SELECTION_VALUE_DESCRIPTION() { return "svdesc"; }

    DefaultReferenceResolver();
    DefaultReferenceResolver(DataTablePtr defaultTable);
};
