#include "event/PersistenceOptions.h"
#include "event/PersistenceBinding.h"


PersistenceOptions::PersistenceOptions()
{

    persistContext = true;
    persistName = true;
    persistExpirationtime = true;
    persistLevel = true;
    persistPermissions = true;
    persistCount = true;
    persistAcknowledgements = true;
    persistEnrichments = true;
    persistFormat = true;
    persistData = true;
}

Cloneable* PersistenceOptions::clone()
{
    PersistenceOptions* clone = new PersistenceOptions;
    clone->persistContext = persistContext;
    clone->persistName = persistName;
    clone->persistExpirationtime = persistExpirationtime;
    clone->persistLevel = persistLevel;
    clone->persistPermissions = persistPermissions;
    clone->persistCount = persistCount;
    clone->persistAcknowledgements = persistAcknowledgements;
    clone->persistEnrichments = persistEnrichments;
    clone->persistFormat = persistFormat;
    clone->persistData = persistData;

    for (std::list<PersistenceBindingPtr>::iterator it= persistenceBindings.begin(); it!=persistenceBindings.end(); ++it) {
        clone->persistenceBindings.push_back( PersistenceBindingPtr( (*it)->clone()) );
    }
    return clone;
}

std::list< PersistenceBindingPtr >  PersistenceOptions::getPersistenceBindings()
{
    return persistenceBindings;
}

void PersistenceOptions::addPersistenceBinding(PersistenceBindingPtr binding)
{
    persistenceBindings.push_back(binding);
}

bool PersistenceOptions::isDedicatedTablePreferred()
{
    return dedicatedTablePreferred;
}

void PersistenceOptions::setDedicatedTablePreferred(bool dedicatedTablePreferred)
{
	this->dedicatedTablePreferred = dedicatedTablePreferred;
}

bool PersistenceOptions::isPerContextTablePreferred()
{
    return perContextTablePreferred;
}

void PersistenceOptions::setPerContextTablePreferred(bool perContextTablePreferred)
{
    this->perContextTablePreferred = perContextTablePreferred;
}

bool PersistenceOptions::isPersistContext()
{
    return persistContext;
}

void PersistenceOptions::setPersistContext(bool persistContext)
{
    this->persistContext = persistContext;
}

bool PersistenceOptions::isPersistName()
{
    return persistName;
}

void PersistenceOptions::setPersistName(bool persistName)
{
    this->persistName = persistName;
}

bool PersistenceOptions::isPersistExpirationtime()
{
    return persistExpirationtime;
}

void PersistenceOptions::setPersistExpirationtime(bool persistExpirationtime)
{
    this->persistExpirationtime = persistExpirationtime;
}

bool PersistenceOptions::isPersistLevel()
{
    return persistLevel;
}

void PersistenceOptions::setPersistLevel(bool persistLevel)
{
    this->persistLevel = persistLevel;
}

bool PersistenceOptions::isPersistPermissions()
{
    return persistPermissions;
}

void PersistenceOptions::setPersistPermissions(bool persistPermissions)
{
    this->persistPermissions = persistPermissions;
}

bool PersistenceOptions::isPersistCount()
{
    return persistCount;
}

void PersistenceOptions::setPersistCount(bool persistCount)
{
    this->persistCount = persistCount;
}

bool PersistenceOptions::isPersistAcknowledgements()
{
    return persistAcknowledgements;
}

void PersistenceOptions::setPersistAcknowledgements(bool persistAcknowledgements)
{
    this->persistAcknowledgements = persistAcknowledgements;
}

bool PersistenceOptions::isPersistEnrichments()
{
    return persistEnrichments;
}

void PersistenceOptions::setPersistEnrichments(bool persistEnrichments)
{
    this->persistEnrichments = persistEnrichments;
}

bool PersistenceOptions::isPersistFormat()
{
    return persistFormat;
}

void PersistenceOptions::setPersistFormat(bool persistFormat)
{
    this->persistFormat = persistFormat;
}

bool PersistenceOptions::isPersistData()
{
    return persistData;
}

void PersistenceOptions::setPersistData(bool persistData)
{
    this->persistData = persistData;
}

void PersistenceOptions::setPersistenceBindings(std::list<PersistenceBindingPtr> persistenceBindings)
{
    this->persistenceBindings = persistenceBindings;
}
