#pragma once

#include "datatable/FieldFormat.h"
#include "datatable/TableFormat.h"
#include "expression/Expression.h"
#include "datatable/AggreGateBean.h"

class PersistenceBinding  : public AggreGateBean , public Cloneable
{

private:    
    static TableFormatPtr FORMAT_;
    AgString name;
    AgString type;
    AgString index;
    AgString expression;
    ExpressionPtr compiledExpression;

public:
    static AgString TYPE_BOOLEAN_() { return "boolean"; }
    static AgString TYPE_STRING_() { return "string"; }
    static AgString TYPE_INT_() { return "int"; }
    static AgString TYPE_LONG_() { return "long"; }
    static AgString TYPE_FLOAT_() { return "float"; }
    static AgString TYPE_DOUBLE_() { return "double"; }
    static AgString TYPE_TIMESTAMP_() { return "timestamp"; }

    AgString getType();
    AgString getIndex();
    AgString getName();
    AgString getExpression();
    ExpressionPtr getCompiledExpression();
    void setName(const AgString & name);
    void setType(const AgString & type);
    void setIndex(const AgString & index);
    void setExpression(const AgString & expression);
    virtual PersistenceBinding *clone();
    int hashCode();
    bool equals(AgObject* obj);
    AgString toString();

	PersistenceBinding();
    PersistenceBinding(DataRecordPtr record);
    PersistenceBinding(const AgString & name, const AgString & type, const AgString & index, const AgString & expression);

    static TableFormatPtr FORMAT();
}; 
