#include "event/FireEventRequestController.h"


FireEventRequestController::FireEventRequestController(boost::posix_time::time_duration  customExpirationPeriod)
    : DefaultRequestController()
{
    this->ignoreStorageErrors = false;
    this->customExpirationPeriod = customExpirationPeriod;
}

FireEventRequestController::FireEventRequestController(bool ignoreStorageErrors) 
    : DefaultRequestController()
{
    this->ignoreStorageErrors = ignoreStorageErrors;
}

boost::posix_time::time_duration FireEventRequestController::getCustomExpirationPeriod()
{
    return customExpirationPeriod;
}

void FireEventRequestController::setCustomExpirationPeriod(boost::posix_time::time_duration  customExpirationPeriod)
{
    this->customExpirationPeriod = customExpirationPeriod;
}

bool FireEventRequestController::isIgnoreStorageErrors()
{
    return ignoreStorageErrors;
}

void FireEventRequestController::setIgnoreStorageErrors(bool ignoreStorageErrors)
{
    this->ignoreStorageErrors = ignoreStorageErrors;
}

EventPtr FireEventRequestController::process(EventPtr event)
{
    return event;
}
