#pragma once

#include "Cres.h"
#include "context/Context.h"
#include "context/ContextUtils.h"
#include "context/EventDefinition.h"
#include "datatable/DataRecord.h"
#include "datatable/DataTable.h"
#include "datatable/FieldFormat.h"
#include "datatable/TableFormat.h"
#include "event/EventLevel.h"
#include "util/Util.h"

#include <boost/date_time/posix_time/posix_time.hpp>

class EventUtils
{
public:

    static AgString FIELD_SEVERITY_STATS_COLOR() { return "color"; }
    static AgString FIELD_SEVERITY_STATS_NUMBER() { return  "number"; }
    static AgString FIELD_SEVERITY_STATS_LEVEL() { return  "level"; }

    static int64_t generateEventId(); 
    static std::list<EventDefinitionPtr>  getEvents(Context* context, const AgString & eventsMask, CallerControllerPtr caller);
    static bool matchesToMask(const AgString & eventMask, EventDefinitionPtr ed);
    static bool matchesToMask(const AgString & eventMask, const AgString & event);
    static DataTablePtr createSeverityStatisticsTable(int none, int notice, int info, int warning, int error, int fatal);

    EventUtils();
};
