#include "event/EventLevel.h"
#include "Cres.h"

std::map<int, AgString> EventLevel::LEVELS_;
std::map<int, AgString> EventLevel::SELECTION_VALUES_;


bool EventLevel::isValid(int level)
{
    return (LEVELS().find(level) != LEVELS().end());
}

const AgString EventLevel::getName(int level)
{
    std::map<int, AgString>::iterator it = LEVELS().find(level);
    if (it != LEVELS().end())
    {
        return it->second;
    }

    return AgString("");
}

std::map<int, AgString> EventLevel::getSelectionValues()
{
    return SELECTION_VALUES();
}

std::map<int, AgString> EventLevel::LEVELS()
{
    typedef std::pair<int, AgString> levelPair;

    if (LEVELS_.empty()) {
        LEVELS_.insert( levelPair(NOTICE(), Cres::get()->getString("conElNotice")) );
        LEVELS_.insert( levelPair(INFO(), Cres::get()->getString("conElInfo")) );
        LEVELS_.insert( levelPair(WARNING(), Cres::get()->getString("conElWarning")) );
        LEVELS_.insert( levelPair(ERROR_(), Cres::get()->getString("conElError")) );
        LEVELS_.insert( levelPair(FATAL(), Cres::get()->getString("conElFatal")) );
        LEVELS_.insert( levelPair(NONE(), Cres::get()->getString("conElNotDefined")) );
    }

    return LEVELS_;
}

std::map<int, AgString> EventLevel::SELECTION_VALUES()
{
    typedef std::pair<int, AgString> levelPair;

    if (SELECTION_VALUES_.empty()) {
        SELECTION_VALUES_.insert( levelPair(0, Cres::get()->getString("none")) );

        for (int i = 1; i <= EventLevel::NUM_LEVELS(); i++) {
            SELECTION_VALUES_.insert( levelPair(i, getName(i)) );
        }
    }

    return SELECTION_VALUES_;
}
