#pragma once

#include "event/ContextEventListener.h"
#include "event/ContextEventListenerInfo.h"
#include "util/AgObject.h"

#include "boost/thread.hpp"
#include <boost/unordered_set.hpp>

class ContextEventListenerSet
{
private:
    boost::recursive_mutex mutex;
    boost::unordered_set<AgObjectPtr> listeners;
	static ContextEventListenerInfoPtr getListenerInfo(AgObjectPtr ref);

public:
    boost::unordered_set<ContextEventListenerPtr>    getListeners();
    boost::unordered_set<ContextEventListenerInfoPtr> getListenersInfo();
    bool addListener(ContextEventListenerPtr listener, bool weak);
    bool removeListener(ContextEventListenerPtr listener);
    bool contains(ContextEventListenerPtr listener);
    void clear();
    int size();

    void lock() { mutex.lock(); }
    void unlock() { mutex.unlock(); }

};
