#ifndef _DiscoveryResultItem_H_
#define _DiscoveryResultItem_H_

#include <boost/shared_ptr.hpp>
#include "discovery/DiscoverableServiceDefinition.h"
#include "discovery/DeviceRecommendation.h"
#include "discovery/DiscoveryProvider.h"
#include "datatable/DataRecord.h"
#include "util/Pointers.h"

class DiscoverableServiceDefinition;

class DiscoveryResultItem
{
private:
    DiscoverableServiceDefinitionPtr serviceDefinition;
    DeviceRecommendationPtr deviceRecommendation;
	DataRecordPtr parameters;

public:
    DiscoverableServiceDefinitionPtr getServiceDefinition();
	DataRecordPtr getParameters();
    void setParameters(DataRecordPtr parametersDataRecord);
    AgString getDeviceName();
    AgString getDeviceDescription();
    DiscoveryProviderPtr getDiscoveryProvider();
    AgString getServiceName();
    AgString getServiceDescription();
    bool isEnabledByDefault();
    DataTablePtr getParametersTable();
    DeviceRecommendationPtr getDeviceRecommendation();
    AgString toString();

    DiscoveryResultItem(DiscoverableServiceDefinitionPtr aDiscoverableServiceDefinition,
                        DataRecordPtr parametersDataRecord);
    DiscoveryResultItem(DiscoverableServiceDefinitionPtr aDiscoverableServiceDefinition,
                        DataRecordPtr parametersDataRecord, DeviceRecommendationPtr aDeviceRecommendation);
};

#endif 
