#include "discovery/DiscoveryResultItem.h"


DiscoveryResultItem::DiscoveryResultItem(
        DiscoverableServiceDefinitionPtr aDiscoverableServiceDefinition,
        DataRecordPtr parametersDataRecord
)
{
    this->serviceDefinition = aDiscoverableServiceDefinition;
    setParameters(parametersDataRecord);
}

DiscoveryResultItem::DiscoveryResultItem(
        DiscoverableServiceDefinitionPtr aDiscoverableServiceDefinition,
        DataRecordPtr parametersDataRecord,
        DeviceRecommendationPtr aDeviceRecommendation
){
    this->deviceRecommendation = aDeviceRecommendation;
    this->serviceDefinition = aDiscoverableServiceDefinition;
    setParameters(parametersDataRecord);
}

DiscoverableServiceDefinitionPtr DiscoveryResultItem::getServiceDefinition()
{
    return serviceDefinition;
}

DataRecordPtr DiscoveryResultItem::getParameters()
{
    return parameters;
}

void DiscoveryResultItem::setParameters(DataRecordPtr parametersDataRecord)
{
    this->parameters = parametersDataRecord;
}

AgString DiscoveryResultItem::getDeviceName()
{
    if (deviceRecommendation != NULL)
        return deviceRecommendation->getName();

    return "";
}

AgString DiscoveryResultItem::getDeviceDescription()
{
    if (deviceRecommendation != NULL)
        return deviceRecommendation->getDescription();

    return "";
}

DiscoveryProviderPtr DiscoveryResultItem::getDiscoveryProvider()
{
    return serviceDefinition->getDiscoveryProvider();
}

AgString DiscoveryResultItem::getServiceName()
{
    return serviceDefinition->getName();
}

AgString DiscoveryResultItem::getServiceDescription()
{
    return serviceDefinition->getDescription();
}

bool DiscoveryResultItem::isEnabledByDefault()
{
    return serviceDefinition->isEnabledByDefault();
}

DataTablePtr DiscoveryResultItem::getParametersTable()
{
    return (DataTablePtr)parameters->wrap();
}

DeviceRecommendationPtr DiscoveryResultItem::getDeviceRecommendation()
{
    return deviceRecommendation;
}

AgString DiscoveryResultItem::toString()
{
    return AgString("DiscoveryResultItem [recommendation= ") + deviceRecommendation->toString() +
            AgString(", parameters= ") + parameters->toString() + AgString("]");
}

