#ifndef _DiscoveryProvider_H_
#define _DiscoveryProvider_H_

#include "discovery/DiscoverableServiceDefinition.h"
#include "context/CallerController.h"
#include "device/DeviceContext.h"
#include "datatable/DataTable.h"
#include "util/Interface.h"
#include "util/Cloneable.h"
#include "util/AgObject.h"
#include <string>
#include <list>

class DiscoveryProvider : public AgObject, public Interface, public Cloneable
{
	virtual AgString getName() = 0;
    virtual AgString getDescription() = 0;
    virtual AgString getDriver() = 0;
	virtual std::list<VariableDefinitionPtr> getDiscoverySettingsVariableDefinitions();
	virtual DataTablePtr getDiscoverySettings(const AgString& settingsVariable) = 0;
	virtual std::list<DiscoverableServiceDefinitionPtr>  getAvailableServices() = 0;
    virtual DeviceContextPtr createDevice(const AgString& username, const AgString& deviceName,
                                        const AgString& description, const AgString& address,
                                        CallerControllerPtr caller)  = 0;
	virtual DiscoverableServiceDefinitionPtr getDiscoverableServiceDefinition(const AgString& name) = 0;
    virtual void configureService(const AgString & name, bool enable, DeviceContextPtr deviceContext,
								  DataTablePtr parameters, CallerControllerPtr callerController)=0; ;
};
#endif 
