#pragma once

#include "util/Cloneable.h"
#include "discovery/DiscoveryResultItem.h"
#include "discovery/DiscoverableService.h"
#include <string>
#include <list>
#include <boost/shared_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>
#include "datatable/DataTable.h"


class DiscoveryProvider;

class DiscoverableServiceDefinition : public AgObject,  public Cloneable, public boost::enable_shared_from_this<DiscoverableServiceDefinition>
{
private:
    DiscoveryProviderPtr discoveryProvider;
    AgString name;
    AgString description;

 /**
   * In most cases, every record in this table defines an instance of connection and authentication "credentials".
   * 
   * Some services, such as TCP port checker, use the whole table for a single check.
   */

    DataTablePtr connectionOptions;
    int64_t discoveryTimeout;
    int discoveryRetries;
    bool useService;
    bool isEnabledByDefault_;

public:
    virtual DiscoverableServicePtr createServiceInstance() = 0;
    AgString getName();
    DataTablePtr getConnectionOptions();
    void setConnectionOptions(DataTablePtr connectionOptions);
    AgString getDescription();
    int64_t getDiscoveryTimeout();
    void setDiscoveryTimeout(int64_t defaultDiscoveryTimeoutInt);
    int getDiscoveryRetries();
    void setDiscoveryRetries(int defaultDiscoveryRetries);
    DiscoveryProviderPtr getDiscoveryProvider();
    AgString deviceType(const AgString& addressStrings);
    int priority();

	void setUseService(bool useService);
    bool isUseService();
    bool isEnabledByDefault();
	std::list<DiscoveryResultItemPtr>  check(const AgString& addressString, int64_t timeoutMilliseconds, int triesCountInt);
	AgString toString();

    DiscoverableServiceDefinition(DiscoveryProviderPtr discoveryProvider, const AgString& name, const AgString& description,
                                  DataTablePtr connectionOptions, int defaultDiscoveryTimeout, int defaultDiscoveryRetries,
                                  bool isEnabledByDefault1);
	
};
