#include "discovery/DiscoverableServiceDefinition.h"
#include "device/ServerDeviceController.h"


DiscoverableServiceDefinition::DiscoverableServiceDefinition(
        DiscoveryProviderPtr discoveryProvider,
        const AgString& name,
        const AgString& description,
        DataTablePtr connectionOptions,
        int defaultDiscoveryTimeout,
        int defaultDiscoveryRetries,
        bool isEnabledByDefault1
){
    this->discoveryProvider = discoveryProvider;
    this->name = name;
    this->description = description;
    setConnectionOptions(connectionOptions);
    setDiscoveryTimeout(defaultDiscoveryTimeout);
    setDiscoveryRetries(defaultDiscoveryRetries);
    this->isEnabledByDefault_ = isEnabledByDefault1;
}


AgString DiscoverableServiceDefinition::getName()
{
    return name;
}

DataTablePtr DiscoverableServiceDefinition::getConnectionOptions()
{
    return connectionOptions;
}

void DiscoverableServiceDefinition::setConnectionOptions(DataTablePtr connectionOptions)
{
    this->connectionOptions =connectionOptions;
}

AgString DiscoverableServiceDefinition::getDescription()
{
    return description;
}

int64_t DiscoverableServiceDefinition::getDiscoveryTimeout()
{
    return discoveryTimeout;
}

void DiscoverableServiceDefinition::setDiscoveryTimeout(int64_t defaultDiscoveryTimeoutInt)
{
    this->discoveryTimeout = defaultDiscoveryTimeoutInt;
}

int DiscoverableServiceDefinition::getDiscoveryRetries()
{
    return discoveryRetries;
}

void DiscoverableServiceDefinition::setDiscoveryRetries(int defaultDiscoveryRetries)
{
    this->discoveryRetries = defaultDiscoveryRetries;
}

DiscoveryProviderPtr DiscoverableServiceDefinition::getDiscoveryProvider()
{
    return discoveryProvider;
}

AgString DiscoverableServiceDefinition::deviceType(const AgString& addressStrings)
{
    UNUSED(addressStrings);
    return ServerDeviceController::TYPE_GENERIC();
}

int DiscoverableServiceDefinition::priority()
{
    return 0;
}

void DiscoverableServiceDefinition::setUseService(bool useService)
{
    this->useService = useService;
}

bool DiscoverableServiceDefinition::isUseService()
{
    return useService;
}

bool DiscoverableServiceDefinition::isEnabledByDefault()
{
    return isEnabledByDefault_;
}

std::list<DiscoveryResultItemPtr>  DiscoverableServiceDefinition::check(const AgString& addressString, int64_t timeoutMilliseconds, int triesCountInt)
{
    return createServiceInstance()->check(shared_from_this(), addressString, timeoutMilliseconds, triesCountInt);
}

AgString DiscoverableServiceDefinition::toString()
{
    return "DiscoverableServiceDefinition " +name +" [" +discoveryProvider->toString() +", " +", timeout=" +AgString::fromInt64(discoveryTimeout)
       +", retries=" +AgString::fromInt(discoveryRetries) +", options=" +connectionOptions->toString() +"]";
}
