#ifndef SettingSynchronizationOptionsH
#define SettingSynchronizationOptionsH

#include "device/DeviceContext.h"
#include "expression/Expression.h"
#include "util/Cloneable.h"
#include <string>


class SettingSynchronizationOptions : public Cloneable
{

private:
    int mode;
    int64_t  updateHistoryStorageTime;
    int64_t  syncPeriod;
    int historyRate;
    AgString filter;
    AgString master;
    AgString condition;
	ExpressionPtr filterExpression;
    ExpressionPtr conditionExpression;
    SynchronizationHandlerPtr synchronizationHandler;
    int synchronizationsCounter;


public:
    int getMode();
    void setMode(int mode);
    int64_t  getSyncPeriod();
    void setSyncPeriod(int64_t  syncPeriod);
    AgString getMaster();
    void setMaster(const AgString & master);
    int64_t  getUpdateHistoryStorageTime();
    void setUpdateHistoryStorageTime(int64_t  updateHistoryStorageTime);
    int getHistoryRate();
    void setHistoryRate(int historyRate);
    AgString getFilter();
    ExpressionPtr getFilterExpression();
    void setFilter(const AgString & filter);
    AgString getCondition();
    ExpressionPtr getConditionExpression();
    void setCondition(const AgString & condition);
    SynchronizationHandlerPtr getSynchronizationHandler();
    void setSynchronizationHandler(SynchronizationHandlerPtr synchronizationHandler);
    int getSynchronizationsCounter();
    void incrementSynchronizationsCounter();
    SettingSynchronizationOptions* clone();

    SettingSynchronizationOptions();
    SettingSynchronizationOptions(int64_t  syncPeriod);
    SettingSynchronizationOptions(int64_t  updateHistoryStorageTime, int64_t  syncPeriod);
    SettingSynchronizationOptions(int64_t  updateHistoryStorageTime, int64_t  syncPeriod, int historyRate);
};


#endif 
