#include "device/DeviceSettingStatus.h"
#include "util/simpleobject/AgString.h"

TableFormatPtr DeviceSettingStatus::FORMAT_;

DeviceSettingStatus::DeviceSettingStatus()
{
    this->duration = 0;
    this->direction = DeviceContext::DIRECTION_DEVICE_TO_SERVER;
}


AgDatePtr DeviceSettingStatus::getTime()
{
    return time;
}

void DeviceSettingStatus::setTime(AgDatePtr time)
{
    this->time = time;
}

int64_t DeviceSettingStatus::getDuration()
{
    return duration;
}

void DeviceSettingStatus::setDuration(int64_t duration)
{
    this->duration = duration;
}

bool DeviceSettingStatus::isUpdated()
{
    return updated;
}

void DeviceSettingStatus::setUpdated(bool updated)
{
    this->updated = updated;
}

int DeviceSettingStatus::getDirection()
{
    return direction;
}

void DeviceSettingStatus::setDirection(int direction)
{
    this->direction = direction;
}

AgString DeviceSettingStatus::getError()
{
    return error;
}

void DeviceSettingStatus::setError(const AgString& error)
{
    this->error = error;
}

TableFormatPtr DeviceSettingStatus::FORMAT()
{
    if (!FORMAT_) {
        FORMAT_ = TableFormatPtr(new TableFormat());
        FORMAT_->addField("<" + FIELD_NAME() + "><S>");
        FORMAT_->addField("<" + FIELD_TIME() + "><D><F=N>");
        FORMAT_->addField("<" + FIELD_DURATION() + "><L><F=N>");
        FORMAT_->addField("<" + FIELD_UPDATED() + "><B>");
        FORMAT_->addField("<" + FIELD_DIRECTION() + "><I><A=" + AgString::fromInt(DeviceContext::DIRECTION_DEVICE_TO_SERVER) + ">");
        FORMAT_->addField("<" + FIELD_ERROR() + "><S><F=N>");
    }

    return FORMAT_;
}
