#include "device/AbstractDeviceDriver.h"
#include "device/DeviceUtils.h"

AbstractDeviceDriver::AbstractDeviceDriver()
{

}

AbstractDeviceDriver::AbstractDeviceDriver(const AgString & description, TableFormatPtr connectionPropertiesFormat) :
    BasePlugin(description)
{
    this->connectionPropertiesFormat = connectionPropertiesFormat;
}

AbstractDeviceDriver::AbstractDeviceDriver(const AgString & description, const AgString & protocol, TableFormatPtr connectionProperties) 
    : BasePlugin(description)
{
    this->connectionPropertiesFormat = connectionProperties;
    this->protocol = protocol;
}


AgString AbstractDeviceDriver::getPrimaryAddress()
{
    return AgString();
}


AgString AbstractDeviceDriver::getStatus()
{
    return AgString();
}

//not used
std::list<Expression>  AbstractDeviceDriver::getStatusExpressions(CallerControllerPtr aCallerController)
{
    UNUSED(aCallerController);
    std::list<Expression> list;
    return list;
}

void AbstractDeviceDriver::setupDeviceContext(DeviceContextPtr deviceContext) 
{
    this->deviceContext = deviceContext;
}

void AbstractDeviceDriver::configureDeviceAccount(DeviceContextPtr deviceContext, CallerControllerPtr caller) 
{
    UNUSED(deviceContext);
    UNUSED(caller);
}

void AbstractDeviceDriver::accessSettingUpdated(const AgString & /*name*/)
{
}

bool AbstractDeviceDriver::shouldSynchronize(::SynchronizationParametersPtr parameters) 
{
    UNUSED(parameters);
    return true;
}

void AbstractDeviceDriver::startSynchronization() 
{
}

bool AbstractDeviceDriver::isUsesConnections()
{
    return true;
}

bool AbstractDeviceDriver::isConnected()
{
    return connected;
}

void AbstractDeviceDriver::connect() 
{
    setConnected(true);
}

bool AbstractDeviceDriver::isUsesAssets()
{
    return false;
}

//not used
std::list<DeviceAssetDefinition>  AbstractDeviceDriver::readAssets()
{
    std::list<DeviceAssetDefinition> list;
    return list;
}

bool AbstractDeviceDriver::isUseDeviceSideValuesCache()
{
    return false;
}

std::list<VariableDefinition>  AbstractDeviceDriver::readVariableDefinitions()
{
    std::list<VariableDefinition> list;
    return list;
}


std::list<VariableDefinition>   AbstractDeviceDriver::readVariableDefinitions(std::list<DeviceAssetDefinition> groups)
{
    UNUSED(groups);
    std::list<VariableDefinition> list;
    return list;
}


std::list<FunctionDefinition>   AbstractDeviceDriver::readFunctionDefinitions()
{
    std::list<FunctionDefinition> list;
    return list;
}

std::list<FunctionDefinition>   AbstractDeviceDriver::readFunctionDefinitions(std::list<DeviceAssetDefinition> groups)
{
    UNUSED(groups);
    std::list<FunctionDefinition> list;
    return list;
}

std::list<EventDefinition>   AbstractDeviceDriver::readEventDefinitions()
{
    std::list<EventDefinition> list;
    return list;
}

std::list<EventDefinition>   AbstractDeviceDriver::readEventDefinitions(std::list<DeviceAssetDefinition> groups)
{
    UNUSED(groups);
    std::list<EventDefinition> list;
    return list;
}

DataTablePtr AbstractDeviceDriver::readVariableValue(VariableDefinitionPtr vd)
{
    UNUSED(vd);
    return DataTablePtr();
}

void AbstractDeviceDriver::writeVariableValue(VariableDefinitionPtr vd, DataTablePtr value, DataTablePtr deviceValue) 
{
    UNUSED(vd);
    UNUSED(value);
    UNUSED(deviceValue);
}

//not used
DataTablePtr AbstractDeviceDriver::executeFunction(FunctionDefinitionPtr fd, DataTablePtr parameters)
{
    UNUSED(fd);
    UNUSED(parameters);
    return DataTablePtr();
}

AgDatePtr AbstractDeviceDriver::getVariableModificationTime(const AgString & /*name*/)
{
    return AgDatePtr();
}

void AbstractDeviceDriver::updateVariableModificationTime(const AgString & /*name*/, AgDatePtr value)
{
    UNUSED(value);
}

VariableStatusPtr AbstractDeviceDriver::getCustomVariableStatus(const AgString & /*name*/)
{
    return VariableStatusPtr();
}

void AbstractDeviceDriver::disconnect()
{
    setConnected(false);
}

void AbstractDeviceDriver::finishSynchronization()
{
}

void AbstractDeviceDriver::setConnected(bool connected)
{
    this->connected = connected;
}


DeviceContextPtr AbstractDeviceDriver::getDeviceContext()
{
    return deviceContext;
}

DiscoveryProviderPtr AbstractDeviceDriver::createDiscoveryProvider()
{
    return DiscoveryProviderPtr();
}

AgString AbstractDeviceDriver::getProtocol()
{
    return protocol;
}

TableFormatPtr AbstractDeviceDriver::getConnectionPropertiesFormat()
{
    return connectionPropertiesFormat;
}

TableFormatPtr AbstractDeviceDriver::createConnectionPropertiesFormat()
{
    TableFormatPtr format = getConnectionPropertiesFormat();
    if(format == 0) {
        format = TableFormatPtr(new TableFormat(int(1), int(1)));
    } else {
        format = TableFormatPtr(format->clone());
    }
    format->addField(DeviceUtils::getInstance().getDESCRIPTION_FIELD(), int(0));
    format->addField(DeviceUtils::getInstance().getNAME_FIELD(), int(0));
    return format;
}

VariableDefinitionPtr AbstractDeviceDriver::discoverVariable(const AgString & /*name*/, AgObjectPtr helper)
{
    UNUSED(helper);
    return VariableDefinitionPtr();
}

FunctionDefinitionPtr AbstractDeviceDriver::discoverFunction(const AgString & /*name*/, AgObjectPtr helper)
{
    UNUSED(helper);
    return FunctionDefinitionPtr();
}

EventDefinitionPtr AbstractDeviceDriver::discoverEvent(const AgString & /*name*/, AgObjectPtr helper)
{
    UNUSED(helper);
    return EventDefinitionPtr();
}
