#pragma once
#include "datatable/validator/AbstractFieldValidator.h"
#include "util/simpleobject/AgString.h"

class RegexValidator : public AbstractFieldValidator
{
private:
    AgString regex;
    AgString message;

public:
    RegexValidator(const AgString& source);
    RegexValidator(const AgString& regex, const AgString& message);

    virtual bool shouldEncode();
    virtual AgString encode();
    virtual char getType();
    virtual AgObjectPtr validate(AgObjectPtr value);
    virtual bool equals(AgObject* obj);
    int hashCode();
    virtual RegexValidator *clone();
};
