#include "datatable/validator/RegexValidator.h"
#include "datatable/FieldFormat.h"
//#include <regex>
#include <boost/functional/hash.hpp>
#include "datatable/ValidationException.h"
#include "util/StringUtils.h"
#include "GlobalVars.h"

RegexValidator::RegexValidator(const AgString& source)
{
    std::vector<AgString> parts = StringUtils::splitRegExp(source, AGG_GLOBAL.SEPARATOR_REGEX);
    this->regex = parts[0];
    if (parts.size() > 1)
    {
        this->message = parts[1];
    }
}

RegexValidator::RegexValidator(const AgString& regex, const AgString& message)
{
    this->regex = regex;
    this->message = message;
}

bool RegexValidator::shouldEncode()
{
    return true;
}

AgString RegexValidator::encode()
{
    return regex + (message.length() != 0 ? AGG_GLOBAL.SEPARATOR + message : "");
}

char RegexValidator::getType()
{
    return AGG_GLOBAL.VALIDATOR_REGEX;
}

AgObjectPtr RegexValidator::validate(AgObjectPtr value)
{
    //todo
    //assert(0);
    /*if (!std::regex_match(value->toString(), std::regex(regex)))
    {
        throw ValidationException("dtValueDoesNotMatchPattern,  RegexValidator::validate");
    }*/
    return value;
}

int RegexValidator::hashCode()
{
    //static int prime = 31;
    int result = 1;
    //todo
    assert(0);
    /*boost::hash<AgString> string_hash;
    result = prime * result + ((message.length() == NULL) ? 0 : string_hash(message));
    result = prime * result + ((regex.length() == NULL) ? 0 : string_hash(regex));*/
    return result;
}

RegexValidator *RegexValidator::clone()
{
    return new RegexValidator(regex, message);
}

bool RegexValidator::equals(AgObject* obj)
{
    if (this == obj)
    {
        return true;
    }

    if (!AbstractFieldValidator::equals(obj))
    {
        return false;
    }

    RegexValidator *other = dynamic_cast<RegexValidator*>(obj);
    if (!other)
        return false;

    if (message != other->message) {
        return false;
    }

    if (regex != other->regex) {
        return false;
    }

    return true;
}


