#include "datatable/validator/IdValidator.h"
#include "datatable/FieldFormat.h"
#include "util/simpleobject/AgString.h"
#include "util/Util.h"
#include "GlobalVars.h"

IdValidator::IdValidator()
{
}

bool IdValidator::shouldEncode()
{
    return true;
}

AgString IdValidator::encode()
{
    return "";
}

char IdValidator::getType()
{
    return AGG_GLOBAL.VALIDATOR_ID;
}

AgObjectPtr IdValidator::validate(AgObjectPtr value)
{
    AgString *str;

    if (value.get() != NULL && (str = dynamic_cast<AgString *>(value.get())))
    {
        AgString retStr = Util::descriptionToName(*str);
        AgObjectPtr agStr = AgObjectPtr(new AgString(retStr));
        return agStr;
    }

    return value;
}

IdValidator *IdValidator::clone()
{
    return new IdValidator();
}


