#pragma once

#include "datatable/FieldFormat.h"
#include <map>

class StringFieldFormat : public FieldFormat
{
public:
    StringFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

    static AgString encodeExpressionEditorOptions(std::map<ReferencePtr, AgString> references);
    static AgString encodeExpressionEditorOptions(ContextPtr defaultContext, DataTablePtr defaultTable, std::map<ReferencePtr, AgString> references);


protected:
    std::list<AgString> getSuitableEditors();
    AgObjectPtr convertValue(AgObjectPtr value);
};

