#include "datatable/field/StringFieldFormat.h"
#include "util/simpleobject/AgString.h"
#include "datatable/TableFormat.h"
#include "datatable/DataRecord.h"
#include "context/Context.h"
#include "expression/Reference.h"
#include "GlobalVars.h"

StringFieldFormat::StringFieldFormat(const AgString &name) : FieldFormat(name)
{
    setTransferEncode(true);
}

char StringFieldFormat::getType()
{
    return AGG_GLOBAL.STRING_FIELD;
}

std::string StringFieldFormat::getFieldClass()
{
    return typeid(AgString).name();
}

std::string StringFieldFormat::getFieldWrappedClass()
{
    return typeid(AgString).name();
}

AgObjectPtr StringFieldFormat::getNotNullDefault()
{
    return AgObjectPtr(new AgString(""));
}

AgObjectPtr StringFieldFormat::valueFromString(const AgString &value, ClassicEncodingSettingsPtr /*settings*/, bool /*validate*/)
{
    return AgObjectPtr(new AgString(value));
}

AgString StringFieldFormat::valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings)
{
    UNUSED(settings);
    AgString *str = dynamic_cast<AgString *>(value.get());
    if (value)
        return *str;
    else
        return "";
}

AgString StringFieldFormat::encodeExpressionEditorOptions(std::map<ReferencePtr, AgString> references)
{
    return encodeExpressionEditorOptions(ContextPtr(), DataTablePtr(), references);
}

AgString StringFieldFormat::encodeExpressionEditorOptions(ContextPtr defaultContext, DataTablePtr defaultTable, std::map<ReferencePtr, AgString> references)
{
    UNUSED(defaultContext);
    UNUSED(defaultTable);
    UNUSED(references);
    //not used
    assert(0);
    /*if (EXPRESSION_BUILDER_OPTIONS_FORMAT.get() == NULL)
    {
        EXPRESSION_BUILDER_OPTIONS_FORMAT = TableFormatPtr(new TableFormat(1, 1));
        EXPRESSION_BUILDER_OPTIONS_FORMAT->addField("<" + FIELD_DEFAULT_CONTEXT + "><S><F=N>");
        EXPRESSION_BUILDER_OPTIONS_FORMAT->addField("<" + FIELD_DEFAULT_TABLE + "><T><F=N>");
        EXPRESSION_BUILDER_OPTIONS_FORMAT->addField("<" + FIELD_REFERENCES + "><T>");
    }

    if (ADDITIONAL_REFERENCES_FORMAT.get() == NULL)
    {
        ADDITIONAL_REFERENCES_FORMAT = TableFormatPtr(new TableFormat());
        ADDITIONAL_REFERENCES_FORMAT->addField("<" + FIELD_ADDITIONAL_REFERENCES_REFERENCE + "><S>");
        ADDITIONAL_REFERENCES_FORMAT->addField("<" + FIELD_ADDITIONAL_REFERENCES_DESCRIPTION + "><S>");
    }

    DataRecordPtr op = DataRecordPtr(new DataRecord(EXPRESSION_BUILDER_OPTIONS_FORMAT));

    AgString temp = defaultContext.get() != NULL ? defaultContext->getPath() : "";
    op->addValue(AgObjectPtr(new AgString(temp)));
    op->addValue(defaultTable);

    DataTablePtr refs = DataTablePtr(new DataTable(ADDITIONAL_REFERENCES_FORMAT));

    if (references.size() != NULL)
    {
        for (std::map<ReferencePtr, AgString>::iterator entry = references.begin(); entry != references.end(); ++entry)
        {
            refs->addRecord()->addString(entry->first->getImage()).addString(entry->second);
        }
    }
    op->addValue(refs);

    return op->wrap()->encode(false);*/
    return "";
}

std::list<AgString> StringFieldFormat::getSuitableEditors()
{
    std::list<AgString> list;
    list.push_back(AGG_GLOBAL.EDITOR_LIST);
    list.push_back(AGG_GLOBAL.EDITOR_CONTEXT_MASK);
    list.push_back(AGG_GLOBAL.EDITOR_CONTEXT);
    list.push_back(AGG_GLOBAL.EDITOR_TEXT_AREA);
    list.push_back(AGG_GLOBAL.EDITOR_EMBEDDED_TEXT_AREA);
    list.push_back(AGG_GLOBAL.EDITOR_TEXT);
    list.push_back(AGG_GLOBAL.EDITOR_CODE);
    list.push_back(AGG_GLOBAL.EDITOR_REFERENCE);
    list.push_back(AGG_GLOBAL.EDITOR_EXPRESSION);
    list.push_back(AGG_GLOBAL.EDITOR_TARGET);
    list.push_back(AGG_GLOBAL.EDITOR_ACTIVATOR);
    list.push_back(AGG_GLOBAL.EDITOR_PASSWORD);
    list.push_back(AGG_GLOBAL.EDITOR_BAR);
    list.push_back(AGG_GLOBAL.EDITOR_BYTES);
    list.push_back(AGG_GLOBAL.EDITOR_FONT);
    list.push_back(AGG_GLOBAL.EDITOR_IP);
    list.push_back(AGG_GLOBAL.EDITOR_HTML);
    return list;
}

AgObjectPtr StringFieldFormat::convertValue(AgObjectPtr value)
{
    if (value.get() == NULL)
        return value;

    AgString *str = dynamic_cast<AgString *>(value.get());

    if (str)
    {
        return AgObjectPtr(new AgString(value->toString()));
    }

    return value;
}
