#include "datatable/field/FloatFieldFormat.h"
#include "util/simpleobject/AgFloat.h"
#include "util/Util.h"
#include "GlobalVars.h"

FloatFieldFormat::FloatFieldFormat(const AgString &name) : FieldFormat(name)
{

}

char FloatFieldFormat::getType()
{
    return AGG_GLOBAL.FLOAT_FIELD;
}

std::string FloatFieldFormat::getFieldClass()
{
    return typeid(AgFloat).name();
}

std::string FloatFieldFormat::getFieldWrappedClass()
{
    return typeid(AgFloat).name();
}

AgObjectPtr FloatFieldFormat::getNotNullDefault()
{
    return AgObjectPtr(new AgFloat(0));
}

AgObjectPtr FloatFieldFormat::valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate)
{
    UNUSED(settings);
    UNUSED(validate);
    if (value.length() == 0)
    {
          return AgObjectPtr(new AgFloat(0));
    }

    return AgObjectPtr(new AgFloat(value.toFloat()));
}

AgString FloatFieldFormat::valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings)
{
    UNUSED(settings);
    return value.get() == NULL ? "" : value->toString();
}

std::list<AgString> FloatFieldFormat::getSuitableEditors()
{
    std::list<AgString> list;
    list.push_back(AGG_GLOBAL.EDITOR_LIST);
    list.push_back(AGG_GLOBAL.EDITOR_BAR);
    list.push_back(AGG_GLOBAL.EDITOR_BYTES);
    return list;
}

AgObjectPtr FloatFieldFormat::convertValue(AgObjectPtr value)
{
    if (value.get() == NULL)
        return value;

    AgFloat *f = dynamic_cast<AgFloat *>(value.get());

    if (f)
    {
        return AgObjectPtr(Util::convertToNumber(value, true, false));
    }

    return value;
}
