#include "datatable/field/DoubleFieldFormat.h"
#include "util/simpleobject/AgDouble.h"
#include "util/Util.h"
#include "GlobalVars.h"

DoubleFieldFormat::DoubleFieldFormat(const AgString &name) : FieldFormat(name)
{

}

char DoubleFieldFormat::getType()
{
    return AGG_GLOBAL.DOUBLE_FIELD;
}

std::string DoubleFieldFormat::getFieldClass()
{
    return typeid(AgDouble).name();
}

std::string DoubleFieldFormat::getFieldWrappedClass()
{
    return typeid(AgDouble).name();
}

AgObjectPtr DoubleFieldFormat::getNotNullDefault()
{
    return AgObjectPtr(new AgDouble(0));
}

AgObjectPtr DoubleFieldFormat::valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate)
{
    UNUSED(settings);
    UNUSED(validate);
    if (value.length() == 0)
    {
        return AgObjectPtr(new AgDouble(0));
    }
    return AgObjectPtr(new AgDouble(value.toDouble()));
}

AgString DoubleFieldFormat::valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings)
{
    UNUSED(settings);

    if (value.get() == 0)
    {
        return "";
    }
    else
    {
        return value->toString();
    }
}

std::list<AgString> DoubleFieldFormat::getSuitableEditors()
{
    std::list<AgString> list;
    list.push_back(AGG_GLOBAL.EDITOR_LIST);
    return list;
}

AgObjectPtr DoubleFieldFormat::convertValue(AgObjectPtr value)
{
    if (value.get() == NULL)
        return value;

    AgDouble *d = dynamic_cast<AgDouble *>(value.get());
    if (d)
    {
        return AgObjectPtr(Util::convertToNumber(value, true, false));
    }
    return value;
}

