#pragma once

#include "datatable/FieldFormat.h"
#include "util/simpleobject/AgDate.h"

class DateFieldFormat : public FieldFormat
{
public:
    DateFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

    static boost::posix_time::ptime timestampFromString(const std::string str);

protected:
    std::list<AgString> getSuitableEditors();
private:
    AgDate date;
};
