#pragma once

#include "datatable/FieldFormat.h"

class DataFieldFormat : public FieldFormat
{
public:
    static const int TRANSCODER_VERSION = 0;

    static AgString EDITOR_TEXT() { return "dtext"; }
    static AgString EDITOR_REPORT() { return "report"; }

    static const char SEPARATOR = '/';

    static AgString EXTENSIONS_DESCR_FIELD() { return "extensionsDescr"; }
    static AgString MODE_FIELD() { return "mode"; }
    static AgString EXTENSIONS_FIELD() { return "extensions"; }
    static AgString EXTENSION_FIELD() { return "extension"; }

    static AgString FOLDER_FIELD() { return "folder"; }

public:
    DataFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

    static AgString encodeTextEditorOptions(const AgString &mode);
    static AgString encodeTextEditorOptions(const AgString &extensionsDescription, const AgString &folder, std::list<AgString> extensions);
    static AgString encodeTextEditorOptions(const AgString &mode, const AgString &extensionsDescription, const AgString &folder, std::list<AgString> extensions);

protected:
    std::list<AgString> getSuitableEditors();

private:
    static TableFormatPtr EXTENSIONS_FORMAT;
    static TableFormatPtr DATA_EDITOR_OPTIONS_FORMAT;
};
