#include "datatable/field/ColorFieldFormat.h"
#include "util/simpleobject/AgColor.h"
#include "util/StringUtils.h"
#include "util/simpleobject/AgString.h"
#include "GlobalVars.h"
#include <stdio.h>

ColorFieldFormat::ColorFieldFormat(const AgString &name) : FieldFormat(name)
{

}

char ColorFieldFormat::getType()
{
    return AGG_GLOBAL.COLOR_FIELD;
}

std::string ColorFieldFormat::getFieldClass()
{
    return typeid(AgColor).name();
}

std::string ColorFieldFormat::getFieldWrappedClass()
{
    return typeid(AgColor).name();
}

AgObjectPtr ColorFieldFormat::getNotNullDefault()
{
    return AgObjectPtr(new AgColor(0, 0, 0));
}

AgObjectPtr ColorFieldFormat::valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate)
{
    UNUSED(settings);
    UNUSED(validate);
    std::string valueUtf8 = value.toUtf8();

    if (valueUtf8.length() > 0 && valueUtf8[0] == '#')
    {
        unsigned int r, g, b;
        //if (valueUtf8.length() > 7)
          //  sscanf_s(valueUtf8.c_str(), "#%02X%02X%02X%02X", &r, &g, &b, &a);
        //else
            sscanf(valueUtf8.c_str(), "#%02X%02X%02X", &r, &g, &b);

        return AgObjectPtr(new AgColor(r, g, b));
    }
    else
    {
        return AgObjectPtr(new AgColor(value.toInt()));
    }
    return AgObjectPtr();
}

AgString ColorFieldFormat::valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings)
{
    UNUSED(settings);
    AgColor *color = dynamic_cast<AgColor *>(value.get());
    if (color)
    {
        return StringUtils::colorToString(*color);
    }
    return "";
}

std::list<AgString> ColorFieldFormat::getSuitableEditors()
{
    std::list<AgString> list;
    list.push_back(AGG_GLOBAL.EDITOR_LIST);
    list.push_back(AGG_GLOBAL.EDITOR_BOX);
    return list;
}
