#pragma once
#include <map>
#include "util/simpleobject/AgString.h"

class TransferEncodingHelper
{
private:
    static std::map<AgChar, AgChar> DIRECT;
    static std::map<AgChar, AgChar> REVERSE;

    static std::map<AgChar, AgChar> initDIRECT();
    static std::map<AgChar, AgChar> initREVERSE();

    static const AgChar ESC_CHAR = '%';

    static const AgChar ELEMENT_START = 0x1c;
    static const AgChar ELEMENT_END = 0x1d;
    static const AgChar ELEMENT_NAME_VALUE_SEPARATOR = 0x1e;

    static const AgChar ELEMENT_VISIBLE_START = '<';
    static const AgChar ELEMENT_VISIBLE_END = '>';
    static const AgChar ELEMENT_VISIBLE_NAME_VALUE_SEPARATOR = '=';

    static const AgChar DATA_TABLE_NULL = 0x001a;

public:
    static AgString encode(const AgString& s);
    static AgString decode(const AgString& s);

};
