#pragma once

#include "datatable/converter/FormatConverter.h"
#include "util/simpleobject/AgString.h"

class AbstractFormatConverter : public FormatConverter
{
private:
    AgString valueClass;
    TableFormatPtr format;

public:
    AbstractFormatConverter(const AgString& valueClassType, TableFormatPtr format);
    AbstractFormatConverter(const AgString& valueClassType);

    virtual AgString getValueClass();
    void setValueClass(const AgString& valueClassType);

    virtual TableFormatPtr getFormat();
    virtual FieldFormat* createFieldFormat(const AgString &name);
};
