#pragma once

#include "datatable/AbstractDataTableBindingProvider.h"
#include <string>
#include "util/Pointers.h"

class DataTableBindingProvider : public AbstractDataTableBindingProvider
{
 //private:

public:
    static AgString PROPERTY_ENABLED() { return "enabled"; }
    static AgString PROPERTY_HIDDEN() { return "hidden"; }
    static AgString PROPERTY_CHOICES() { return "choices"; }
    static AgString PROPERTY_OPTIONS() { return "options"; }

public:
    DataTableBindingProvider(DataTablePtr table);
    DataTableBindingProvider(DataTablePtr table, ErrorCollectorPtr errorCollector);

    std::map<BindingPtr, EvaluationOptionsPtr> createBindings();
    void stop();
    void start();
    void writeReference(int method, ReferencePtr ref, ReferencePtr cause, AgObjectPtr value, ChangeCachePtr cache);

protected:
    virtual void callReferenceChanged(ReferencePtr cause, int method, ReferenceListenerPtr listener);
    virtual ReferenceWriterPtr getExternalReferenceWriter();
    virtual void setCellValue(AgObjectPtr value, int row, const AgString& field);
    virtual void setEnabled(AgObjectPtr value, int row, const AgString& field);
    virtual void setHidden(AgObjectPtr value, int row, const AgString& field);
    virtual void setOptions(AgObjectPtr value, int row, const AgString& field);
    virtual void setSelectionValues(AgObjectPtr value, int row, const AgString& field);
    virtual void setEditorEnabled(bool enabled);
    FieldFormat* getFieldFormat(int row, const AgString& field);

private:
    DataTablePtr table;
    bool headless;
};
