#include "datatable/AggreGateBean.h"
#include "datatable/DataTableConversion.h"
#include "datatable/DataRecord.h"

AggreGateBean::AggreGateBean(TableFormatPtr format)
{
    this->format = format;
    DataTableConversion::instance().populateBeanFromRecord(this, DataRecordPtr(new DataRecord(format)), format, true);
}

AggreGateBean::AggreGateBean(TableFormatPtr format, DataRecordPtr data)
{
    this->format = format;
    DataTableConversion::instance().populateBeanFromRecord(this, data, format, true);

}

DataTablePtr AggreGateBean::toDataTable()
{
    return DataTableConversion::instance().beanToTable(this, format, true, true);
}

DataRecordPtr AggreGateBean::toDataRecord()
{
    return DataTableConversion::instance().beanToRecord(this, format, true, true);
}

TableFormatPtr AggreGateBean::getFormat()
{
    return format;
}




