#ifndef UserH
#define UserH

#include "util/simpleobject/AgString.h"
#include <stdint.h>

class User
{
private:
    int64_t id;
    AgString name;
    AgString password;
    AgString firstname;
    AgString lastname;
    AgString email;
    AgString company;
    AgString department;
    AgString comments;
    AgString timezone;
    AgString phone;
    AgString fax;
    AgString address1;
    AgString address2;
    AgString city;
    AgString region;
    AgString zip;
    int country;
    AgString locale;
    AgString datepattern;
    AgString timepattern;
    int weekStart;

public:
    AgString getAddress1();
    AgString getAddress2();
    AgString getCity();
    AgString getComments();
    AgString getCompany();
    int getCountry();
    AgString getDepartment();
    AgString getEmail();
    AgString getFax();
    AgString getFirstname();
    AgString getLastname();
    AgString getFullName();
    AgString getPassword();
    AgString getPhone();
    AgString getRegion();
    AgString getTimezone();
    AgString getName();
    AgString getZip();
    int64_t getId();
    AgString getLocale();
    AgString getDatepattern();
    AgString getTimepattern();
    void setZip(const AgString& zip);
    void setName(const AgString& username);
    void setTimezone(const AgString& timezone);
    void setRegion(const AgString& region);
    void setPhone(const AgString& phone);
    void setPassword(const AgString& password);
    void setLastname(const AgString& lastname);
    void setFirstname(const AgString& firstname);
    void setFax(const AgString& fax);
    void setEmail(const AgString& email);
    void setDepartment(const AgString& department);
    void setCountry(int country);
    void setCompany(const AgString& company);
    void setComments(const AgString& comments);
    void setCity(const AgString& city);
    void setAddress2(const AgString& address2);
    void setAddress1(const AgString& address1);
    void setId(int64_t  id);
    void setLocale(const AgString& locale);
    void setDatepattern(const AgString& datepattern);
    void setTimepattern(const AgString& timepattern);
    int getWeekStart();
    void setWeekStart(int weekStart);
    AgString toString();
    AgString createDescription(const AgString& firstname, const AgString& lastname, const AgString& username, bool showUsername);

    User();

    static AgString FIELD_NAME;
    static AgString FIELD_FIRSTNAME;
    static AgString FIELD_LASTNAME;
    static AgString FIELD_PASSWORD;
    static AgString FIELD_COUNTRY;
    static AgString FIELD_REGION;
    static AgString FIELD_ZIP;
    static AgString FIELD_CITY;
    static AgString FIELD_ADDRESS1;
    static AgString FIELD_ADDRESS2;
    static AgString FIELD_COMMENTS;
    static AgString FIELD_COMPANY;
    static AgString FIELD_DEPARTMENT;
    static AgString FIELD_EMAIL;
    static AgString FIELD_PHONE;
    static AgString FIELD_FAX;
    static AgString FIELD_TIMEZONE;
    static AgString FIELD_LOCALE;
    static AgString FIELD_DATEPATTERN;
    static AgString FIELD_TIMEPATTERN;
    static AgString FIELD_WEEK_START;

    static AgString DEFAULT_ADMIN_USERNAME;
    static AgString DEFAULT_ADMIN_PASSWORD;

	static AgString DEFAULT_LOCALE;
};


#endif
