#include "data/User.h"
#include "util/DateUtils.h"

AgString User::FIELD_NAME = "name";
AgString User::FIELD_FIRSTNAME = "firstname";
AgString User::FIELD_LASTNAME = "lastname";
AgString User::FIELD_PASSWORD = "password";
AgString User::FIELD_COUNTRY = "country";
AgString User::FIELD_REGION = "region";
AgString User::FIELD_ZIP = "zip";
AgString User::FIELD_CITY = "city";
AgString User::FIELD_ADDRESS1 = "address1";
AgString User::FIELD_ADDRESS2 = "address2";
AgString User::FIELD_COMMENTS = "comments";
AgString User::FIELD_COMPANY = "company";
AgString User::FIELD_DEPARTMENT = "department";
AgString User::FIELD_EMAIL = "email";
AgString User::FIELD_PHONE = "phone";
AgString User::FIELD_FAX = "fax";
AgString User::FIELD_TIMEZONE = "timezone";
AgString User::FIELD_LOCALE = "locale";
AgString User::FIELD_DATEPATTERN = "datepattern";
AgString User::FIELD_TIMEPATTERN = "timepattern";
AgString User::FIELD_WEEK_START = "weekStart";

AgString User::DEFAULT_ADMIN_USERNAME = "admin";
AgString User::DEFAULT_ADMIN_PASSWORD = "admin";

AgString User::DEFAULT_LOCALE = "en";


User::User()
{
    locale = DEFAULT_LOCALE;
    datepattern = DateUtils::DEFAULT_DATE_PATTERN();
    timepattern = DateUtils::DEFAULT_TIME_PATTERN();
    weekStart = 0;
}

AgString User::getAddress1()
{
    return address1;
}

AgString User::getAddress2()
{
    return address2;
}

AgString User::getCity()
{
    return city;
}

AgString User::getComments()
{
    return comments;
}

AgString User::getCompany()
{
    return company;
}

int User::getCountry()
{
    return country;
}

AgString User::getDepartment()
{
    return department;
}

AgString User::getEmail()
{
    return email;
}

AgString User::getFax()
{
    return fax;
}

AgString User::getFirstname()
{
    return firstname;
}

AgString User::getLastname()
{
    return lastname;
}

AgString User::getFullName()
{
    return AgString(firstname).append( (lastname.length() ? " " + lastname : "") );
}

AgString User::getPassword()
{
    return password;
}

AgString User::getPhone()
{
    return phone;
}

AgString User::getRegion()
{
    return region;
}

AgString User::getTimezone()
{
    return timezone;
}

AgString User::getName()
{
    return name;
}

AgString User::getZip()
{
    return zip;
}

int64_t User::getId()
{
    return id;
}

AgString User::getLocale()
{
    return locale;
}

AgString User::getDatepattern()
{
    return datepattern;
}

AgString User::getTimepattern()
{
    return timepattern;
}

void User::setZip(const AgString& zip)
{
    this->zip = zip;
}

void User::setName(const AgString& username)
{
    this->name = username;
}

void User::setTimezone(const AgString& timezone)
{
    this->timezone = timezone;
}

void User::setRegion(const AgString& region)
{
    this->region = region;
}

void User::setPhone(const AgString& phone)
{
    this->phone = phone;
}

void User::setPassword(const AgString& password)
{
    this->password = password;
}

void User::setLastname(const AgString& lastname)
{
    this->lastname = lastname;
}

void User::setFirstname(const AgString& firstname)
{
    this->firstname = firstname;
}

void User::setFax(const AgString& fax)
{
    this->fax = fax;
}

void User::setEmail(const AgString& email)
{
    this->email = email;
}

void User::setDepartment(const AgString& department)
{
    this->department = department;
}

void User::setCountry(int country)
{
    this->country = country;
}

void User::setCompany(const AgString& company)
{
    this->company = company;
}

void User::setComments(const AgString& comments)
{
    this->comments = comments;
}

void User::setCity(const AgString& city)
{
    this->city = city;
}

void User::setAddress2(const AgString& address2)
{
    this->address2 = address2;
}

void User::setAddress1(const AgString& address1)
{
    this->address1 = address1;
}

void User::setId(int64_t id)
{
    this->id = id;
}

void User::setLocale(const AgString& locale)
{
    this->locale = locale;
}

void User::setDatepattern(const AgString& datepattern)
{
    this->datepattern = datepattern;
}

void User::setTimepattern(const AgString& timepattern)
{
    this->timepattern = timepattern;
}

int User::getWeekStart()
{
    return weekStart;
}

void User::setWeekStart(int weekStart)
{
    this->weekStart = weekStart;
}

AgString User::toString()
{
    return createDescription(firstname, lastname, name, true);
}

AgString User::createDescription(const AgString& firstname, const AgString& lastname, const AgString& username, bool showUsername)
{
    bool hasFirst = firstname.length() > 0;
    bool hasLast = lastname.length() > 0;

    AgString desc = username;

    if (hasFirst || hasLast) {
        if (showUsername) {
            desc = desc + " (";
        }else {
            desc = "";
        }

        desc = desc + (hasFirst ? firstname : "");
        desc = desc + (hasLast ? (hasFirst ? " " : "") + lastname : "");

        if (showUsername) {
            desc = desc + ")";
        }
    }

    return desc;
}

