#pragma once

#include <string>
#include <sstream>
#include <iostream>
#include "util/simpleobject/AgString.h"

class Location
{
private:
    float latitude;
    float longitude;

public:
    float getLatitude() {
        return latitude;
    }

    void setLatitude(float latitude) {
        this->latitude = latitude;
    }

    float getLongitude() {
        return longitude;
    }

    void setLongitude(float longitude) {
        this->longitude = longitude;
    }

    AgString toString()
    {
        AgString ss;
        ss += "[Lat=" + AgString::fromFloat(latitude) + ", Lon=" + AgString::fromFloat(longitude) + "]";
        return ss;
    }

    Location(float latitude, float longitude) {
        this->latitude = latitude;
        this->longitude = longitude;
    }

    Location(double latitude, double longitude) {
        this->latitude = static_cast<float>(latitude);
        this->longitude = static_cast<float>(longitude);
    }
};
