#ifndef EventH
#define EventH

#include "util/Cloneable.h"
#include <boost/shared_ptr.hpp>
#include <list>
#include "util/Pointers.h"
#include "util/simpleobject/AgString.h"
#include "util/TimeHelper.h"

class Event: public Cloneable
{
 private:
    void init();
    void init_(const AgString & context, const AgString & name, int level, DataTablePtr data, int64_t  id);
	
	int64_t id;
    AgDatePtr instantiationtime;
    AgDatePtr creationtime;
    AgDatePtr  expirationtime;
	AgString context;
	AgString name;
    std::list<AcknowledgementPtr> acknowledgements;
	DataTablePtr data;
	int listener;
	int level;
	PermissionsPtr permissions;
	int count;
	std::list<EnrichmentPtr> enrichments;
	AgObjectPtr originator;
	AgString deduplicationId;

public:
    static int64_t DEFAULT_EVENT_EXPIRATION_PERIOD() { return 100 * TimeHelper::DAY_IN_MS(); } // Milliseconds
    Event();
    Event(const AgString& context, EventDefinitionPtr def, int level, DataTablePtr data, int64_t id, AgDatePtr creationtime, PermissionsPtr permissions);
	Event(const AgString& context, const AgString& name, int level, DataTablePtr data, int64_t id);
  
    int64_t getId();
    AgDatePtr getInstantiationtime();
    AgDatePtr getCreationtime();
    AgString getContext();
	AgString getName();
    AgDatePtr getExpirationtime();
    DataTablePtr getAcknowledgementsTable();
    DataTablePtr getEnrichmentsTable();
    void setAcknowledgementsTable(DataTablePtr data);
	void setEnrichmentsTable(DataTablePtr data);
	void addAcknowledgement(AcknowledgementPtr ack);
	std::list<AcknowledgementPtr> getAcknowledgements();
	void addEnrichment(EnrichmentPtr enrichment);
    std::list<EnrichmentPtr> getEnrichments();

	void setId(int64_t id);
    void setCreationtime(AgDatePtr creationtime);
	void setName(const AgString &name);
    void setContext(const AgString& context);
    void setExpirationtime(AgDatePtr expirationtime);
	void setData(DataTablePtr data);
	void setListener(int listener);
    void setLevel(int level);
	void setOriginator(AgObjectPtr originator);
	DataTablePtr getData();
	int getListener();
    int getLevel();
    PermissionsPtr getPermissions();
	void setPermissions(PermissionsPtr permissions);
	AgObjectPtr getOriginator();
	int getCount();
	void setCount(int count);
	AgString getDeduplicationId();
    void setDeduplicationId(const AgString& deduplicationId);
    Event *clone();
	int hashCode();
    bool equals(Event* obj);
	AgString toString();
};

#endif
