#ifndef DataH
#define DataH
#include "util/Pointers.h"
#include "util/Cloneable.h"
#include "util/AgObject.h"
#include "util/simpleobject/AgString.h"
#include <context/ContextManager.h>
#include <context/CallerController.h>

#include <string>
#include <vector>
#include <map>
#include <stdint.h>

class Data : public Cloneable, public AgObject
{

public:
	Data();  
    Data(const std::vector<unsigned char> &data);
    Data(const AgString &name, const std::vector<unsigned char> &data);

    void setPreview(const std::vector<unsigned char> &preview);
	void setId(int64_t id);  
    void setData(const std::vector<unsigned char> &data);
    void setBlob(const std::vector<unsigned char> &blob);
    void setName(const AgString &name);

    std::vector<unsigned char> getPreview();
    AgString getName();
	int64_t getId();
    std::vector<unsigned char> &getData();
    std::vector<unsigned char> &getBlob();
    std::map< AgString,  AgObjectPtr > getAttachments();

    std::vector<unsigned char> fetchData(ContextManager* cm, CallerControllerPtr cc);

    AgString toDetailedString();

    void setAttachments(std::map<AgString, AgObjectPtr > &attachments);

    virtual Data* clone();
    virtual bool equals(AgObject* obj);

    int compareTo(Comparable *obj);
    virtual std::string getClass();
    virtual int hashCode();
    virtual AgString toString();

private:
	int64_t id;
    AgString name;
    std::vector<unsigned char> preview;
    std::vector<unsigned char> data;
    std::map<AgString, AgObjectPtr > attachments;

    int checksum(const std::vector<unsigned char> &bytes);
    inline AgString formStringHelper(const AgString &str);

};

#endif
