#ifndef VariableDefinitionH
#define VariableDefinitionH

#define BOOST_THREAD_USE_LIB

#include "context/AbstractEntityDefinition.h"
#include "util/Cloneable.h"
#include "util/Comparable.h"
#include "util/Pointers.h"
#include <boost/date_time/posix_time/posix_time.hpp>

#include <list>

class VariableDefinition : public AbstractEntityDefinition, public Cloneable , public Comparable
{

private:
    TableFormatPtr format;
    bool readable;
	bool writable;
    bool hidden;
	PermissionsPtr readPermissions;
	PermissionsPtr writePermissions;
	AgString helpId;
	VariableGetterPtr getter;
	VariableSetterPtr setter;
    bool allowUpdateEvents;
    boost::posix_time::time_duration changeEventsExpirationPeriod;
    bool localCachingEnabled;
    boost::posix_time::time_duration remoteCacheTime;
    std::string valueClass;
	std::list< CompatibilityConverterPtr >  compatibilityConverters;
	bool persistent;
	DataTablePtr defaultValue;


   void init(const AgString & name, TableFormatPtr format, bool readable, bool writable, const AgString & description);

public:
	void setFormat(TableFormatPtr format);
    void setReadable(bool readable);
	void setWritable(bool writable);
	void setHidden(bool hidden);
	void setGroup(const AgString & group);
	void setReadPermissions(PermissionsPtr readPermissions);
	void setWritePermissions(PermissionsPtr writePermissions);
	void setSetter(VariableSetterPtr setter);
	void setGetter(VariableGetterPtr getter);
	TableFormatPtr getFormat();
	bool isReadable();
	bool isWritable();
	bool isHidden();
    PermissionsPtr getReadPermissions();
	PermissionsPtr getWritePermissions();
    VariableSetterPtr getSetter();
	VariableGetterPtr getGetter();
	AgString getHelpId();
	void setHelpId(const AgString & helpId);
    std::string getValueClass();
    void setValueClass(const std::string& valueClass);
    boost::posix_time::time_duration  getChangeEventsExpirationPeriod();
    void setChangeEventsExpirationPeriod(boost::posix_time::time_duration  changeEventsExpirationPeriod);
    bool isLocalCachingEnabled();
    void setLocalCachingEnabled(bool valueCachingEnabled);
    boost::posix_time::time_duration getRemoteCacheTime();
    void setRemoteCacheTime(boost::posix_time::time_duration remoteCacheTime);
    DataTablePtr getDefaultValue();
    void setDefaultValue(DataTablePtr defaultValue);
    bool isPersistent();
    void setPersistent(bool persistent);
    bool isAllowUpdateEvents();
    void setAllowUpdateEvents(bool allowUpdateEvents);
	void addCompatibilityConverter(CompatibilityConverterPtr converter);
	std::list<CompatibilityConverterPtr>  getCompatibilityConverters();
    VariableDefinition *clone();
    int hashCode();
    bool equals(VariableDefinition* obj);
    int compareTo(Comparable* d);

    VariableDefinition();
 	VariableDefinition(const AgString & name, TableFormatPtr format, bool readable, bool writable);
	VariableDefinition(const AgString & name, TableFormatPtr format, bool readable, bool writable, const AgString & description);
	VariableDefinition(const AgString & name, TableFormatPtr format, bool readable, bool writable, const AgString & description, const AgString & group);

};
#endif
