#include "context/VariableData.h"


VariableData::VariableData(VariableDefinitionPtr definition)
{
    this->getCount = 0;
    this->setCount = 0;
    this->getterCached = false;
    this->setterCached = false;
    this->definition = definition;
}

void VariableData::registerGetOperation()
{
    getCount++;
}

void VariableData::registerSetOperation()
{
    setCount++;
}

VariableDefinitionPtr VariableData::getDefinition()
{
    return definition;
}

AgObjectPtr VariableData::getValue()
{
    return value;
}

void VariableData::setValue(AgObjectPtr value)
{
    this->value = value;
}

boost::shared_mutex& VariableData::getReadWriteLock()
{
    return readWriteLock;
}

int64_t VariableData::getGetCount()
{
    return getCount;
}

int64_t VariableData::getSetCount()
{
    return setCount;
}

bool VariableData::isGetterCached()
{
    return getterCached;
}

void VariableData::setGetterCached(bool getterCached)
{
    this->getterCached = getterCached;
}

bool VariableData::isSetterCached()
{
    return setterCached;
}

void VariableData::setSetterCached(bool setterCached)
{
    this->setterCached = setterCached;
}

int VariableData::compareTo(Comparable *d)
{
    if(d != 0) {
        VariableData* data = dynamic_cast<VariableData*>(d);
        assert(data);
        return definition->compareTo(data->getDefinition().get());
    }
    return 0;
}


void VariableData::setGetterMethod(const std::string &getter)
{
    getterMethod = getter;
}

std::string VariableData::getGetterMethod()
{
    return getterMethod;
}

void VariableData::setSetterMethod(const std::string &setter)
{
    setterMethod = setter;
}

std::string VariableData::getSetterMethod()
{
    return setterMethod;
}
