#include "context/UncheckedCallerController.h"
#include "security/DefaultPermissionChecker.h"
#include "UnsupportedOperationException.h"

UncheckedCallerController::UncheckedCallerController()
    : AbstractCallerController(CallerDataPtr())
{
     permissions = DefaultPermissionChecker::getNullPermissions();
}

UncheckedCallerController::UncheckedCallerController(const AgString & username)
    : AbstractCallerController(CallerDataPtr())
{
    permissions = DefaultPermissionChecker::getNullPermissions();
    setUsername(username);
}


PermissionsPtr UncheckedCallerController::getPermissions()
{
	return permissions;
}

bool UncheckedCallerController::isPermissionCheckingEnabled()
{
    return false;
}

bool UncheckedCallerController::isLoggedIn()
{
    return true;
}

void UncheckedCallerController::logout()
{
}

bool UncheckedCallerController::isHeadless()
{
    return true;
}

void UncheckedCallerController::handleContextEvent(EventPtr event)
{
    UNUSED(event);
    throw UnsupportedOperationException("UncheckedCallerController::handleContextEvent(EventPtr event)");
}



