#ifndef FunctionDefinitionH
#define FunctionDefinitionH
#define BOOST_THREAD_USE_LIB
#include "AbstractEntityDefinition.h"

#include "util/Comparable.h"
#include "util/Cloneable.h"

class FunctionDefinition : public AbstractEntityDefinition, public Cloneable, public Comparable
{
 private:
	TableFormatPtr inputFormat;
    TableFormatPtr outputFormat;
	bool hidden;
    PermissionsPtr permissions;
    FunctionImplementationPtr implementation;
    bool concurrent;

    void init(const AgString &name, TableFormatPtr inputFormat, TableFormatPtr outputFormat, const AgString &description, const AgString &group);

public:
    TableFormatPtr getInputFormat();
    TableFormatPtr getOutputFormat();
    bool isHidden();
    PermissionsPtr getPermissions();
    FunctionImplementationPtr getImplementation();
    void setInputFormat(TableFormatPtr inputFormat);
    void setOutputFormat(TableFormatPtr outputFormat);
    void setHidden(bool hidden);
    void setPermissions(PermissionsPtr perms);
    bool isConcurrent();
    void setConcurrent(bool concurrent);
    void setImplementation(FunctionImplementationPtr implementation);
    Cloneable* clone();
    int compareTo(Comparable *d);
    int hashCode();
    bool equals(FunctionDefinition* other);

    FunctionDefinition(const AgString &name, TableFormatPtr inputFormat, TableFormatPtr outputFormat);
    FunctionDefinition(const AgString &name, TableFormatPtr inputFormat, TableFormatPtr outputFormat, const AgString &description);
    FunctionDefinition(const AgString &name, TableFormatPtr inputFormat, TableFormatPtr outputFormat, const AgString &description, const AgString &group);

};

#endif
