#include "context/FunctionData.h"
#include "context/FunctionDefinition.h"


FunctionData::FunctionData(FunctionDefinitionPtr definition)
{
	implementationCached = false;
	executionCount = 0;
    this->definition = definition;
}


void FunctionData::registerExecution()
{
    executionCount++;
}

FunctionDefinitionPtr FunctionData::getDefinition()
{
    return definition;
}

boost::recursive_mutex& FunctionData::getExecutionLock()
{
    return executionLock;
}

int64_t FunctionData::getExecutionCount()
{
    return executionCount;
}

bool FunctionData::isImplementationCached()
{
    return implementationCached;
}

void FunctionData::setImplementationCached(bool implementationCached)
{
    this->implementationCached = implementationCached;
}

std::string FunctionData::getImplementationMethod()
{
    return implementationMethod;
}

void FunctionData::setImplementationMethod(const std::string &implementationMethod)
{
    this->implementationMethod = implementationMethod;
}


int FunctionData::compareTo(Comparable *d)
{    
    if(d != NULL)
    {
        FunctionData *fd = dynamic_cast<FunctionData *>(d);
        assert(fd);
        return definition->compareTo(fd->getDefinition().get());
    }
    return 0;
}

