#include "context/FireChangeEventRequestController.h"
#include "context/VariableDefinition.h"
#include "datatable/encoding/ClassicEncodingSettings.h"
#include "util/simpleobject/AgDate.h"
#include "data/Event.h"
#include "datatable/DataTable.h"
#include "datatable/DataRecord.h"
#include "context/AbstractContext.h"

FireChangeEventRequestController::FireChangeEventRequestController(
        boost::posix_time::time_duration  customExpirationPeriod,
        VariableDefinitionPtr def,
        DataTablePtr value)
    : FireEventRequestController(customExpirationPeriod)
{
    this->def = def;
    this->value = value;
}

EventPtr FireChangeEventRequestController::process(EventPtr event)
{
    if (event->getExpirationtime().get() == 0)
    {
        return EventPtr();
    }

    DataTablePtr fullValue = def->getFormat().get() == NULL ? value :  DataTablePtr();
    event->getData()->rec()->setValue(AbstractContextStrings::EF_CHANGE_VALUE, fullValue);

    AgString dataOnly = def->getFormat().get() == NULL ? AgString() : value->getEncodedData(
                                                       ClassicEncodingSettingsPtr(new ClassicEncodingSettings(false, true)));
    event->getData()->rec()->setValue(AbstractContextStrings::EF_CHANGE_DATA, AgObjectPtr(new AgString(dataOnly)));
    return event;
}


