#ifndef EventDataH
#define EventDataH

#define BOOST_THREAD_USE_LIB

#include "util/Comparable.h"
#include "util/Pointers.h"
#include <boost/unordered_set.hpp>
#include <boost/thread.hpp>

class EventData: public Comparable, public boost::mutex
{

private:
	EventDefinitionPtr definition;
    ContextEventListenerSetPtr listeners;
	std::list<EventPtr>  history;
    boost::mutex historyMutex;
	int64_t fireCount;

public:
	void registerFiredEvent();
	EventDefinitionPtr getDefinition();
    boost::unordered_set<ContextEventListenerPtr>  getListeners();
    boost::unordered_set<ContextEventListenerInfoPtr>  getListenersInfo();
	int64_t getFireCount();
	bool addListener(ContextEventListenerPtr listener, bool weak);
	bool removeListener(ContextEventListenerPtr listener);
	void clearListeners();
	void dispatch(EventPtr event);
    EventPtr store(EventPtr event, unsigned int customMemoryStorageSize);
	std::list<EventPtr>  getHistory();
    AgString toString();
    int compareTo(Comparable* d);

	EventData(EventDefinitionPtr definition);
};
#endif
