#ifndef EntityReferenceH
#define EntityReferenceH
#include "util/Comparable.h"
#include "util/Cloneable.h"
#include "util/Pointers.h"
#include "util/simpleobject/AgString.h"

class EntityReference : public Cloneable, public Comparable
{
private:
	AgString context;
	AgString entity;

public:
    AgString getContext();
    AgString getEntity();
    AgString getProperty();
    void setContext(const AgString & context);
    void setEntity(const AgString & entity);
    void setProperty(const AgString & property);
    int hashCode();
    //bool equals(EntityReference* obj);
    int compareTo(Comparable* ref);
    Cloneable *clone();

    AgString toString();

    EntityReference();
	EntityReference(const AgString & context, const AgString & entity);

};
#endif
