#ifndef ContextUtilsH
#define ContextUtilsH
 #define BOOST_THREAD_USE_LIB

#include "util/simpleobject/AgString.h"
#include "util/Pointers.h"
#include <list>

class ContextUtils
{
private:
    static std::list<AgString>  expandMaskPart(const AgString & head, const AgString & tail, ContextManager* contextManager, CallerControllerPtr caller, bool useVisibleChildren);

    static AgString CONTEXT_CLASS_SUFFIX() { return "Context"; }

public:
    static AgString CONTEXT_NAME_PATTERN() { return "\\w*"; }
    static AgString CONTEXT_PATH_PATTERN() { return "[\\w|\\.]+"; }
    static AgString CONTEXT_MASK_PATTERN() { return "[\\w|\\.|\\*]+"; }
    static AgString CONTEXT_TYPE_PATTERN () { return "[\\w|\\.]+"; }
    static AgString ENTITY_NAME_PATTERN() { return "\\w+"; }
    static AgString IDENTIFIER_PATTERN() { return "\\w*"; }

    static AgString CONTEXT_NAME_SEPARATOR() { return "."; }
    static AgString CONTEXT_TYPE_SEPARATOR() { return "."; }
    static AgString CONTEXT_GROUP_MASK() { return "*"; }
    static AgString ENTITY_GROUP_MASK() { return "*"; }
    static AgString CONTEXT_TYPE_ANY() { return "*"; }
    static AgString ENTITY_GROUP_SEPARATOR() { return "|"; }
    static AgString MASK_LIST_SEPARATOR() { return " "; }

    static AgString GROUP_DEFAULT() { return "default"; }
    static AgString GROUP_SYSTEM() { return "system"; }
    static AgString GROUP_REMOTE() { return "remote"; }
    static AgString GROUP_CUSTOM() { return "custom"; }
    static AgString GROUP_STATUS() { return "status"; }
    static AgString GROUP_ACCESS() {return "access"; }
	
    static const int ENTITY_VARIABLE = 1;
    static const int ENTITY_FUNCTION = 2;
    static const int ENTITY_EVENT = 4;
    static const int ENTITY_ACTION = 8;

    static AgString USERNAME_PATTERN() { return "%"; }
    static AgString VARIABLES_GROUP_DS_SETTINGS() { return "ds_settings"; }

    static AgString createName(std::vector<AgString>& parts);
    static bool isRelative(const AgString & name);
    static bool isValidContextName(const AgString & s);
    static AgString getTypeForClass(const std::string &className);
    static bool isValidContextType(const AgString & s);
    static AgString getBaseGroup(const AgString & group);

    static std::list<AgString> expandMaskToPaths(const AgString & mask, ContextManager* contextManager);
    static std::list<AgString> expandMaskToPaths(const AgString & mask, ContextManager* contextManager, CallerControllerPtr caller);
    static std::list<AgString> expandMaskToPaths(const AgString & mask, ContextManager* contextManager, CallerControllerPtr caller, bool useVisibleChildren);

    static std::list<Context*>  expandMaskToContexts(const AgString & mask, ContextManager* contextManager);
    static std::list<Context*>  expandMaskToContexts(const AgString & mask, ContextManager* contextManager, CallerControllerPtr caller);
    static std::list<Context*>  expandMaskToContexts(const AgString & mask, ContextManager* contextManager, CallerControllerPtr caller, bool useVisibleChildren);

    static bool matchesToMask(const AgString & mask, const AgString & name);
    static bool matchesToMask(const AgString & mask, const AgString & context, bool contextMayExtendMask, bool maskMayExtendContext);

    static AgString devicesContextPath(AgString owner);

    static bool isMask(const AgString & name);
    static AgString pluginIdToContextName(const AgString & pluginId);

    static AgString pluginUserConfigContextPath(const AgString & username, const AgString & pluginId);
    static AgString pluginGlobalConfigContextPath(const AgString & pluginId);

    static AgString userContextPath(const AgString & username);

    static bool invalidChar (char c);
};

#endif
