#ifndef SimpleCommandParserH
#define SimpleCommandParserH

#include "communication/AbstractCommandParser.h"
#include "communication/Command.h"
#include "communication/CommandParserListener.h"
#include "device/DisconnectionException.h"
#include <boost/optional.hpp>
#include <deque>
#include <boost/asio/streambuf.hpp>

class SimpleCommandParser : public AbstractCommandParser
{
private:
	static const int BUFFER_SIZE = 1024;
    boost::optional<unsigned char> startChar;
	unsigned char endChar;
    boost::optional<unsigned char> endChar2;
    bool needBoth;
    bool started;
    bool waitingEndChar2;
    AggreReadableByteChannelPtr inputChannel;
    bool full;

    boost::asio::streambuf streamBuf;

  	CommandPtr buildCommand();
	bool processBufferContents();
    inline bool processByte(unsigned char cur);
    void init(AggreReadableByteChannelPtr channel, unsigned char startChar, unsigned char endChar);

protected:
    virtual CommandPtr createCommandFromBufferContent() = 0;

public:
	void clearCommand();
    virtual CommandPtr readCommand();
	bool isFull();

    SimpleCommandParser(AggreReadableByteChannelPtr channel, unsigned char startChar, unsigned char endChar);
    SimpleCommandParser(AggreReadableByteChannelPtr channel, unsigned char startChar, unsigned char endChar,
                        unsigned char endChar2, bool needBoth);
    virtual void close();
};

#endif
