#pragma once

#include "util/AgObject.h"
#include "util/Pointers.h"
#include <vector>

class Command : public AgObject
{
 private:
    int64_t  timeout_;
    std::vector<unsigned char> buf_;

protected:
    virtual AgString header();
    virtual AgString footer();

public:
    AgString getContent();
    void add(const AgString & data);    
    void send(BlockingChannelPtr byteChannel);
    void send(BlockingChannelPtr byteChannel, bool encapsulate);
    virtual AgString  getId();
    virtual bool isAsync();
    int64_t  getTimeout();
    void setTimeout(int64_t  timeout_);
    AgString toString();

	Command();
    Command(const AgString & data);
    Command(const std::vector<unsigned char> &data);
    int size();

    void write(unsigned char data);
    void write(const unsigned char *data, int off_src, int size);
};
