#pragma once

#include "binding/DefaultBindingProcessor.h"
#include "binding/ReferenceListener.h"
#include "util/Pointers.h"

class BindingReferenceListener : public ReferenceListener
{
private:
    DefaultBindingProcessor *owner;
    BindingPtr binding;
    AgObjectPtr content;
    EvaluationOptionsPtr options;

public:
    BindingReferenceListener(BindingPtr binding, EvaluationOptionsPtr options, DefaultBindingProcessor *ownerBinding);
    void referenceChanged(ReferencePtr cause, const std::map<AgString, AgObjectPtr>& environment, ChangeCachePtr cache);
    void referenceChanged(ReferencePtr cause, const std::map<AgString, AgObjectPtr>& environment, ChangeCachePtr cache, bool asynchronousProcessing);
    void processReferenceChange(ReferencePtr cause, const std::map<AgString, AgObjectPtr>& environment, ChangeCachePtr cache);
    BindingPtr getBinding();
    void setContent(AgObjectPtr content);
    AgObjectPtr getContent();
    BindingProcessor* getBindingProcessor();
    EvaluationOptionsPtr getEvaluationOptions();
    AgString toString();
};
