#include "binding/Binding.h"
#include "expression/Reference.h"
#include "expression/Expression.h"

Binding::Binding(ReferencePtr reference, ExpressionPtr expression)
{
    id = 0;
    this->reference = reference;
    this->expression = expression;
}

Binding::Binding(const AgString& reference, const AgString& expression)
{
    id = 0;
    this->reference = ReferencePtr(new Reference(reference));
    this->expression = ExpressionPtr(new Expression(expression));
}

ExpressionPtr Binding::getExpression()
{
    return expression;
}

ReferencePtr Binding::getReference()
{
    return reference;
}

Cloneable *Binding::clone()
{
    Binding* clone = new Binding(ReferencePtr(reference->clone()), ExpressionPtr(expression.get() != NULL ? expression->clone() : NULL));
    clone->id = id;
    return clone;
}

AgString Binding::toString()
{
    return reference->toString() + " = " + expression->toString();
}

int64_t Binding::getId() const
{
    return id;
}

void Binding::setId(int64_t id)
{
    this->id = id;
}
